/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/variants.h>
#include <boardid.h>
#include <gpio.h>

int variant_memory_sku(void)
{
	/*
	 * The memory straps in the P0 build don't match those generated by
	 * spd_tools, so override the memory ID to 0.
	 */
	if (board_id() == 0)
		return 0;

	/*
	 * Memory configuration board straps
	 * GPIO_MEM_CONFIG_0	GPP_E1
	 * GPIO_MEM_CONFIG_1	GPP_E2
	 * GPIO_MEM_CONFIG_2	GPP_E3
	 */
	gpio_t spd_gpios[] = {
		GPP_E1,
		GPP_E2,
		GPP_E3,
	};

	return gpio_base2_value(spd_gpios, ARRAY_SIZE(spd_gpios));
}
