/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDialog>
#include <QObject>


/////////////////////// pappsomspp includes
#include <pappsomspp/gui/precisionwidget/precisionwidget.h>

/////////////////////// Local includes
#include <pappsomspp/core/processing/combiners/mzintegrationparams.h>

namespace Ui
{
class MzIntegrationParamsDlg;
}

namespace MsXpS
{
namespace MineXpert
{

class MzIntegrationParamsDlg: public QDialog
{
  Q_OBJECT

  public:
  MzIntegrationParamsDlg(QWidget *parent = nullptr);
  MzIntegrationParamsDlg(
    QWidget *parent,
    const pappso::MzIntegrationParams &mz_integration_params,
    const QColor &color);

  ~MzIntegrationParamsDlg();

  void readSettings();
  void writeSettings();

  void keyPressEvent(QKeyEvent *event);

  void show();
  void setBinningType(pappso::MzIntegrationParams::BinningType binningType);
  void setBinSizePrecisionPtr(pappso::PrecisionPtr bin_size_precsion_p);
  void setDecimalPlaces(int decimal_places);
  void setRemoveZeroValDataPoints(bool apply);
  void setBinSizeDivisor(int divisor);

  QString toString() const;

  public slots:
  void closeEvent(QCloseEvent *event);
  void applyPushButtonClicked();
  void binCreationStrategyGroupBoxToggled(bool checked);

  signals:
  void mzIntegrationParamsChangedSignal(pappso::MzIntegrationParams &params);
  void mzIntegrationParamsDlgShouldBeDestroyedSignal();

  protected:
  pappso::MzIntegrationParams *mp_mzIntegrationParams = nullptr;
  pappso::PrecisionWidget *mp_binSizeModelWidget;
  pappso::PrecisionPtr mp_binSizeModel =
    pappso::PrecisionFactory::getResInstance(40000);
  QColor m_color;
  ::Ui::MzIntegrationParamsDlg *m_ui;

  void setupWidget();
};


} // namespace MineXpert

} // namespace MsXpS
