The Info Tree
=============

The Info Tree is another representation of a successful parse that can be generated by the parsers
in the system. An info tree is similar to a parse tree in that it closely resembles how the grammar
matched the input string. In contrast to a parse tree, an info tree is aimed to provide information
about syntax highlighting and indentation. As such, there are a few differences between a parse tree
and an info tree:

- The info tree captures *all* parts of the parse tree, regardless of what parts of the parse tree
  were captured in the grammar. It is therefore possible to reconstruct the parsed string from an
  info tree. This is not always true for a parse tree in Storm.

- The info tree is not typed. It is a generic, type-less version of the parse tree. It is thus not
  possible to directly transform it into an abstract syntax tree (one may of course traverse it
  manually, but that eliminates many benefits of the Syntax Language). On the other hand, the
  typeless nature makes it possible to create a generic parser for a set of syntax rules, and then
  adjust which rule is the start rule without having to re-create the parser.

- The info tree contains information about syntax highlighting and indentation.

The info tree representation is implemented by the classes `lang.bnf.InfoNode`,
`lang.bnf.InfoInternal`, and `lang.bnf.InfoLeaf`. This representation is used by the [language
server](md:../Storm/Language_Server) to provide syntax highlighting and indentation of source code.