/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.util.XmlUtil;

public class Escape {
    private static final String escapable = "\\\\\tt\rr\nn\"\"";
    static String ESCAPE_SET = " ,./;:_+-~=><?'!@#$%^&*";
    static int nEscape = ESCAPE_SET.length();

    public static String escape(Object object) {
        if (object instanceof String) {
            return Escape.escape("" + object);
        }
        if (object instanceof String[]) {
            return Escape.escape((String[])object, true);
        }
        if (object instanceof int[]) {
            return Escape.toJSON(null, object);
        }
        if (object instanceof Point3f[]) {
            return Escape.escapeArray(object);
        }
        return object.toString();
    }

    public static String escapeColor(int n) {
        return "[x" + Escape.getHexColorFromRGB(n) + "]";
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public static String escape(Point4f point4f) {
        return "{" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "}";
    }

    public static String escape(AxisAngle4f axisAngle4f) {
        return "{" + axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + (float)((double)axisAngle4f.angle * 180.0 / Math.PI) + "}";
    }

    public static String escape(Tuple3f tuple3f) {
        if (tuple3f == null) {
            return "null";
        }
        return "{" + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + "}";
    }

    public static String escape(float[] fArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(fArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String escape(float[][] fArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = bl ? ";\n" : "\n";
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (i > 0) {
                stringBuffer.append(string);
            }
            for (int j = 0; j < fArray[i].length; ++j) {
                stringBuffer.append(fArray[i][j]).append('\t');
            }
        }
        return stringBuffer.toString();
    }

    public static String escape(float[][][] fArray, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = bl ? ";\n" : "\n";
        if (fArray[0] == null || fArray[0][0] == null) {
            return "0 0 0" + string;
        }
        stringBuffer.append(fArray.length).append(" ").append(fArray[0].length).append(" ").append(fArray[0][0].length);
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            stringBuffer.append(string);
            for (int j = 0; j < fArray[i].length; ++j) {
                if (fArray[i][j] == null) continue;
                stringBuffer.append(string);
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    stringBuffer.append(fArray[i][j][k]).append('\t');
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escape(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("" + nArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String escapeChopped(String string) {
        return Escape.chop(Escape.escape(string));
    }

    public static String escape(String string) {
        int n;
        if (string == null) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    stringBuffer.append(string.substring(n3, n2)).append('\\').append(c2);
                    n3 = n2 + 1;
                }
                stringBuffer.append(string.substring(n3, string.length()));
                string = stringBuffer.toString();
            }
        }
        n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            string = string.substring(0, n) + Escape.unicode(string.charAt(n)) + string.substring(n + 1);
        }
        return "\"" + string + "\"";
    }

    private static String chop(String string) {
        int n = string.length();
        if (n < 512) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\"\\\n    + \"";
        int n2 = 0;
        for (int i = 72; i < n; i += 72) {
            while (string.charAt(i - 1) == '\\') {
                ++i;
            }
            stringBuffer.append(n2 == 0 ? "" : string2).append(string.substring(n2, i));
            n2 = i;
        }
        stringBuffer.append(string2).append(string.substring(n2, n));
        return stringBuffer.toString();
    }

    public static String escape(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return Escape.escape("");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(bl ? Escape.escapeNice(stringArray[i]) : Escape.escape(stringArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String escapeArray(Object object) {
        if (object == null) {
            return Escape.escape("");
        }
        if (object instanceof Float) {
            return "" + object;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(dArray[i]);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(fArray[i]);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(nArray[i]);
            }
        } else if (object instanceof Point3f[]) {
            Point3f[] point3fArray = (Point3f[])object;
            stringBuffer = new StringBuffer("array(");
            for (int i = 0; i < point3fArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Escape.escape(point3fArray[i]));
            }
            return stringBuffer.append(")").toString();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String escapeNice(String string) {
        float f = Parser.parseFloatStrict(string);
        return Float.isNaN(f) ? Escape.escape(string) : string;
    }

    private static String unicode(char c) {
        String string = "0000" + Integer.toHexString(c);
        return "\\u" + string.substring(string.length() - 4);
    }

    public static Object unescapePointOrBitsetOrMatrixOrArray(String string) {
        if (string.charAt(0) == '{') {
            return Escape.unescapePoint(string);
        }
        if ((string.startsWith("({") && string.indexOf("({") == string.lastIndexOf("({") || string.startsWith("[{") && string.indexOf("[{") == string.lastIndexOf("[{")) && string.indexOf(44) < 0 && string.indexOf(46) < 0 && string.indexOf(45) < 0) {
            return Escape.unescapeBitset(string);
        }
        if (string.startsWith("[[")) {
            return Escape.unescapeMatrix(string);
        }
        return string;
    }

    public static Object unescapePoint(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.charAt(0) != '{' || string2.charAt(string2.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        string2 = string2.substring(1, string2.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = Parser.parseFloat(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 3) {
            return new Point3f(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static BitSet unescapeBitset(String string) {
        if (string == "{null}") {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = string.length();
        int n2 = -1;
        int n3 = -2;
        if (n < 3) {
            return bitSet;
        }
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '{': 
                case '}': {
                    if (n3 < 0) continue block4;
                    if (n2 < 0) {
                        n2 = n3;
                    }
                    bitSet.set(n2, n3 + 1);
                    n2 = -1;
                    n3 = -2;
                    continue block4;
                }
                case ':': {
                    n2 = n3;
                    n3 = -2;
                    continue block4;
                }
                default: {
                    if (!Character.isDigit(c)) continue block4;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    n3 = (n3 << 3) + (n3 << 1) + (c - 48);
                }
            }
        }
        return bitSet;
    }

    public static Object unescapeMatrix(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.replace('\n', ' ').trim();
        if (string2.lastIndexOf("[[") != 0 || string2.indexOf("]]") != string2.length() - 2) {
            return string;
        }
        float[] fArray = new float[16];
        string2 = string2.substring(2, string2.length() - 2).replace('[', ' ').replace(']', ',');
        int[] nArray = new int[1];
        for (n = 0; n < 16; ++n) {
            fArray[n] = Parser.parseFloat(string2, nArray);
            if (!Float.isNaN(fArray[n])) continue;
            if (nArray[0] >= string2.length() || string2.charAt(nArray[0]) != ',') break;
            nArray[0] = nArray[0] + 1;
            --n;
        }
        if (n == 9) {
            return new Matrix3f(fArray);
        }
        if (n == 16) {
            return new Matrix4f(fArray);
        }
        return string;
    }

    public static String escape(BitSet bitSet, boolean bl) {
        char c;
        char c2 = bl ? (char)'(' : '[';
        char c3 = c = bl ? (char)')' : ']';
        if (bitSet == null) {
            return c2 + "{}" + c;
        }
        StringBuffer stringBuffer = new StringBuffer(c2 + "{");
        int n = bitSet.length();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl2 = bitSet.get(n4);
            if (n4 == n || n2 >= 0 && !bl2) {
                if (n2 >= 0 && n3 != n2) {
                    stringBuffer.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bitSet.get(n4)) continue;
            if (n2 < 0) {
                stringBuffer.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        stringBuffer.append("}").append(c);
        return stringBuffer.toString();
    }

    public static String escape(BitSet bitSet) {
        return Escape.escape(bitSet, true);
    }

    public static String escape(Matrix3f matrix3f) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[[").append(matrix3f.m00).append(",").append(matrix3f.m01).append(",").append(matrix3f.m02).append("]").append(",[").append(matrix3f.m10).append(",").append(matrix3f.m11).append(",").append(matrix3f.m12).append("]").append(",[").append(matrix3f.m20).append(",").append(matrix3f.m21).append(",").append(matrix3f.m22).append("]]");
        return stringBuffer.toString();
    }

    public static String escape(Matrix4f matrix4f) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[[").append(matrix4f.m00).append(",").append(matrix4f.m01).append(",").append(matrix4f.m02).append(",").append(matrix4f.m03).append("]").append(",[").append(matrix4f.m10).append(",").append(matrix4f.m11).append(",").append(matrix4f.m12).append(",").append(matrix4f.m13).append("]").append(",[").append(matrix4f.m20).append(",").append(matrix4f.m21).append(",").append(matrix4f.m22).append(",").append(matrix4f.m23).append("]").append(",[").append(matrix4f.m30).append(",").append(matrix4f.m31).append(",").append(matrix4f.m32).append(",").append(matrix4f.m33).append("]]");
        return stringBuffer.toString();
    }

    private static String packageJSON(String string, StringBuffer stringBuffer) {
        return Escape.packageJSON(string, stringBuffer.toString());
    }

    private static String packageJSON(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "\"" + string + "\": " + string2;
    }

    private static String fixString(String string) {
        if (string == null || string.indexOf("{\"") == 0) {
            return string;
        }
        string = TextFormat.simpleReplace(string, "\"", "''");
        string = TextFormat.simpleReplace(string, "\n", " | ");
        return "\"" + string + "\"";
    }

    public static String toJSON(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (object == null) {
            return Escape.packageJSON(string, (String)null);
        }
        if (object instanceof Integer || object instanceof Float || object instanceof Double) {
            return Escape.packageJSON(string, object.toString());
        }
        if (object instanceof String) {
            return Escape.packageJSON(string, Escape.fixString((String)object));
        }
        if (object instanceof String[]) {
            stringBuffer.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.fixString(((String[])object)[i]));
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof int[]) {
            stringBuffer.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(((int[])object)[i]);
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof float[]) {
            stringBuffer.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(((float[])object)[i]);
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof int[][]) {
            stringBuffer.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.toJSON(null, ((int[][])object)[i]));
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof float[][]) {
            stringBuffer.append("[");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.toJSON(null, ((float[][])object)[i]));
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Vector) {
            stringBuffer.append("[ ");
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.toJSON(null, ((Vector)object).get(i)));
                string2 = ",";
            }
            stringBuffer.append(" ]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Matrix4f) {
            stringBuffer.append(Escape.escape((Matrix4f)object));
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Matrix3f) {
            stringBuffer.append(Escape.escape((Matrix3f)object));
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Tuple3f) {
            stringBuffer.append("[").append(((Tuple3f)object).x).append(",").append(((Tuple3f)object).y).append(",").append(((Tuple3f)object).z).append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof AxisAngle4f) {
            stringBuffer.append("[").append(((AxisAngle4f)object).x).append(",").append(((AxisAngle4f)object).y).append(",").append(((AxisAngle4f)object).z).append(",").append((float)((double)((AxisAngle4f)object).angle * 180.0 / Math.PI)).append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Point4f) {
            stringBuffer.append("[").append(((Point4f)object).x).append(",").append(((Point4f)object).y).append(",").append(((Point4f)object).z).append(",").append(((Point4f)object).w).append("]");
            return Escape.packageJSON(string, stringBuffer);
        }
        if (object instanceof Hashtable) {
            stringBuffer.append("{ ");
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                stringBuffer.append(string2).append(Escape.packageJSON(string3, Escape.toJSON(null, ((Hashtable)object).get(string3))));
                string2 = ",";
            }
            stringBuffer.append(" }");
            return Escape.packageJSON(string, stringBuffer);
        }
        return Escape.packageJSON(string, Escape.fixString(object.toString()));
    }

    public static String toReadable(Object object) {
        return Escape.toReadable(null, object);
    }

    public static String toReadable(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Escape.packageReadable(string, null, Escape.escape((String)object));
        }
        if (object instanceof String[]) {
            stringBuffer.append("[");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.escape(((String[])object)[i]));
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageReadable(string, "String[" + n + "]", stringBuffer);
        }
        if (object instanceof int[]) {
            stringBuffer.append("[");
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(((int[])object)[i]);
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageReadable(string, "int[" + n + "]", stringBuffer);
        }
        if (object instanceof float[]) {
            stringBuffer.append("[");
            int n = ((float[])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(((float[])object)[i]);
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageReadable(string, "float[" + n + "]", stringBuffer);
        }
        if (object instanceof int[][]) {
            stringBuffer.append("[");
            int n = ((int[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.toReadable(null, ((int[][])object)[i]));
                string2 = ",";
            }
            stringBuffer.append("]");
            return Escape.packageReadable(string, "int[" + n + "][]", stringBuffer);
        }
        if (object instanceof float[][]) {
            stringBuffer.append("[\n");
            int n = ((float[][])object).length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2).append(Escape.toReadable(null, ((float[][])object)[i]));
                string2 = ",\n";
            }
            stringBuffer.append("]");
            return Escape.packageReadable(string, "float[][]", stringBuffer);
        }
        if (object instanceof Vector) {
            int n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(Escape.toReadable(string + "[" + (i + 1) + "]", ((Vector)object).get(i)));
            }
            return Escape.packageReadable(string, "Vector[" + n + "]", stringBuffer);
        }
        if (object instanceof Matrix3f) {
            stringBuffer.append(Escape.escape((Matrix3f)object));
            return Escape.packageReadable(string, null, stringBuffer);
        }
        if (object instanceof Tuple3f) {
            stringBuffer.append(Escape.escape((Tuple3f)object));
            return Escape.packageReadable(string, null, stringBuffer);
        }
        if (object instanceof Point4f) {
            stringBuffer.append(Escape.escape((Point4f)object));
            return Escape.packageReadable(string, null, stringBuffer);
        }
        if (object instanceof AxisAngle4f) {
            stringBuffer.append(Escape.escape((AxisAngle4f)object));
            return Escape.packageReadable(string, null, stringBuffer);
        }
        if (object instanceof Hashtable) {
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                stringBuffer.append(Escape.toReadable((string == null ? "" : string + ".") + string3, ((Hashtable)object).get(string3)));
            }
            return stringBuffer.toString();
        }
        return Escape.packageReadable(string, null, object.toString());
    }

    private static String packageReadable(String string, String string2, StringBuffer stringBuffer) {
        return Escape.packageReadable(string, string2, stringBuffer.toString());
    }

    private static String packageReadable(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? "" : string2 + "\t";
        if (string == null) {
            return string4 + string3;
        }
        return "\n" + string + "\t" + (string2 == null ? "" : "*" + string2 + "\t") + string3;
    }

    public static String escapeModelFileNumber(int n) {
        return "" + n / 1000000 + "." + n % 1000000;
    }

    public static Object encapsulateData(String string, Object object) {
        return "  DATA \"" + string + "\"\n" + (object instanceof float[][] ? Escape.escape((float[][])object, true) + ";\n" : (object instanceof float[][][] ? Escape.escape((float[][][])object, true) + ";\n" : object)) + "    END \"" + string + "\";\n";
    }

    public static String escapeXml(Object object) {
        if (object instanceof String) {
            return XmlUtil.wrapCdata(object.toString());
        }
        String string = "" + object;
        if (string.length() == 0 || string.charAt(0) != '[') {
            return string;
        }
        return XmlUtil.wrapCdata(Escape.toReadable(null, object));
    }
}

